var DISABLED = 0;
var MAIN_DEVICE = 1;
var BACKUP_DEVICE = 2;

var NO_CONNECT = 0;
var CONNECT_OK = 1;
var CONNECT_ERROR = 2;
var TARGRT_IN_USE = 3;

var UNUSE = 0;
var IN_USE = 1;

var BACKUP_SWITCH_CONDITION = 3;
var switchCondInpVal;
var switchCondOutpVal;

var backup_enable_set = 0;
var obj_device_ip_set = 0;
var switch_cond_set   = new Array(0,0,0);
var switch_cond_inp_set = 0;
var switch_cond_outp_set = 0;

var i;
var language;
var getParams;
var xmlhttp = getHTTPObject();

var cardBckupMode;

function disabledDevBackup()
{
	var devBacEnabled = document.getElementById("localDevBacEna").value;
	if (devBacEnabled == DISABLED)
	{
		disabledButton(document.getElementById("switch"), true);
	}
	else
	{
		disabledButton(document.getElementById("switch"), false);
	}
}

function DevBacEnaChange()
{
	backup_enable_set = 1;
	disabledDevBackup();
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function GetDeviceBackup()
{
	var backupDeviceInfo;
	var count = 0;
	
	getParams = "type=36&cmd=1&getDeviceBackup=1&language=" + language;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if ((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState == 4)
		{
			if ((bd.browser == "IE") && (language == 1))
			{
				backupDeviceInfo = gb2utf8(xmlhttp.responseBody);
				var index = backupDeviceInfo.indexOf("</html>");
				var bias = backupDeviceInfo.length - index;
				backupDeviceInfo = backupDeviceInfo.slice(7, - bias).split("&");
			}
			else
			{
				backupDeviceInfo = xmlhttp.responseText.slice(7, -8).split("&");
			}
			
			document.getElementById("localDevBacEna").value = backupDeviceInfo[count++];
			disabledDevBackup();
			document.getElementById("objectDeviceIP").value = backupDeviceInfo[count++];
			
			if (backupDeviceInfo[count] == NO_CONNECT)
			{
				if (language == 0)
				{
					document.getElementById("objDevStatus").innerHTML = "No Connect";
				}
				else
				{
					document.getElementById("objDevStatus").innerHTML = "未连接";
				}
			}
			else if (backupDeviceInfo[count] == CONNECT_OK)
			{
				if (language == 0)
				{
					document.getElementById("objDevStatus").innerHTML = "Connect Normal, Status Normal";
				}
				else
				{
					document.getElementById("objDevStatus").innerHTML = "连接正常，状态正常";
				}
			}
			else if (backupDeviceInfo[count] == CONNECT_ERROR)
			{
				if (language == 0)
				{
					document.getElementById("objDevStatus").innerHTML = "Connect Normal, Status Abnormal";
				}
				else
				{
					document.getElementById("objDevStatus").innerHTML = "连接正常，状态异常";
				}
			}
			else
			{
				if (language == 0)
				{
					document.getElementById("objDevStatus").innerHTML = "In Use";
				}
				else
				{
					document.getElementById("objDevStatus").innerHTML = "正在使用";
				}
			}
			count++;
			
			if (backupDeviceInfo[count] == UNUSE)
			{
				if (language == 0)
				{
					document.getElementById("bacStatus").innerHTML = "Local Device Unuse";
				}
				else
				{
					document.getElementById("bacStatus").innerHTML = "本机未使用";
				}
			}
			else
			{
				if (language == 0)
				{
					document.getElementById("bacStatus").innerHTML = "Local Device In Use";
				}
				else
				{
					document.getElementById("bacStatus").innerHTML = "本机正在使用";
				}
			}
			count++;
			
			for(i = 0; i < BACKUP_SWITCH_CONDITION; i++)
			{
				id = i + 1;
				if(backupDeviceInfo[count] == 1)
				{
					document.getElementById("switch_condition" + id).checked = true;
				}
				else
				{
					document.getElementById("switch_condition" + id).checked = false;
				}
				count++;
			}
			
			for(i = 0; i < switchCondInp.length; i++)
			{
				if(switchCondInp[i].value == backupDeviceInfo[count])
				{
					switchCondInp[i].checked = true;
					break;
				}
			}
			count++;
			
			for(i = 0; i < switchCondOutp.length; i++)
			{
				if(switchCondOutp[i].value == backupDeviceInfo[count])
				{
					switchCondOutp[i].checked = true;
					break;
				}
			}
			count++;
			
			cardBckupMode = backupDeviceInfo[count];
			if(cardBckupMode != 0)
			{
				//document.getElementById("localDevBacEna").disabled = true;	//板卡备份和设备备份取消互斥关系
			}
			
			document.body.style.cursor = "auto";
			window.status = "Done";
		}
	}
	
	xmlhttp.send(getParams);
	return false;
}

function ResetSetArrays()
{
	backup_enable_set = 0;
	obj_device_ip_set = 0;
	
	for(i = 0; i < BACKUP_SWITCH_CONDITION; i++)
	{
		switch_cond_set[i] = 0;
	}
	
	switch_cond_inp_set = 0;
	switch_cond_outp_set = 0;
}

function PageLoadHandler()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	GetDeviceBackup();
	ResetSetArrays();
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	language = document.getElementById("language").value;
	var thisForm = document.getElementById("deviceBackup");
	switchCondInp = thisForm.switch_cond_inp;
	switchCondOutp = thisForm.switch_cond_outp;

	PageLoadHandler();
	var apply = document.getElementById("Apply");
	var testRow = document.getElementById("testRow");
	var switchRow = document.getElementById("switchRow");
	applyDispay(parent.group, apply);
	applyDispay(parent.group, testRow);
	applyDispay(parent.group, switchRow);
}

function validateIP(obj)
{
	if (!Validate_IPAddress(obj.value))
	{		
		if (language == 0)
		{
			alert("Invalid IP Address. Please input a valid IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入正确的IP地址。");
		}
		setTimeout(function() {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj_device_ip_set = 1;
	return true;
}

function SwitchCondChange(comp)
{
	EnableApply();
	for(i = 0; i < BACKUP_SWITCH_CONDITION; i++)
	{
		var index = i + 1;
		var Id = "switch_condition" + index;
		if(comp.id == Id)
		{
			switch_cond_set[i] = 1;
		}
	}
}

function SwitchCondInpChange(value)
{
	EnableApply();
	switch_cond_inp_set = 1;
	switchCondInpVal = value;
}

function SwitchCondOutpChange(value)
{
	EnableApply();
	switch_cond_outp_set = 1;
	switchCondOutpVal = value;
}

function SetDeviceBackup()
{
	var obj;
	var devBacEnabled;
	var switchCondVal;

	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Updating device backup information, please wait...";

	getParams = "type=36&cmd=2";
	if(backup_enable_set == 1)
	{
		devBacEnabled = document.getElementById("localDevBacEna").value;
		getParams = getParams + "&localDevBacEna=" + devBacEnabled;
	}
	
	if(obj_device_ip_set == 1)
	{
		obj = document.getElementById("objectDeviceIP");
		if (!validateIP(obj))
		{
			return false;
		}
		else
		{
			getParams = getParams + "&objectDeviceIP=" + obj.value;
		}
	}
		
	for(i = 0; i < BACKUP_SWITCH_CONDITION; i++)
	{
		if(switch_cond_set[i] == 1)
		{
			id = i + 1;
			if(document.getElementById("switch_condition" + id).checked == true)
			{
				switchCondVal = 1;
			}
			else
			{
				switchCondVal = 0;
			}
			getParams = getParams + "&switch_condition" + id + "=" + switchCondVal;
		}
	}

	if(switch_cond_inp_set == 1)
	{
		for(i = 0; i < switchCondInp.length; i++)
		{
			if(switchCondInp[i].checked == true)
			{
				switchCondInpVal = switchCondInp[i].value;
				break;
			}
		}
		getParams = getParams + "&switch_cond_inp=" + switchCondInpVal;
	}
	
	if(switch_cond_outp_set == 1)
	{
		for(i = 0; i < switchCondOutp.length; i++)
		{
			if(switchCondOutp[i].checked == true)
			{
				switchCondOutpVal = switchCondOutp[i].value;
				break;
			}
		}
		getParams = getParams + "&switch_cond_outp=" + switchCondOutpVal;
	}
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState == 4)
		{
			if (language == 0)
			{
				alert("Device backup configuration updated successfully.");
			}
			else
			{
				alert("设备备份参数设置成功。");
			}
			PageLoadHandler();
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

function TestObjDevice()
{
	var confirmResult;
	if (language == 0)
	{
		confirmResult = confirm("After the test,you need to refresh target device's status manually.\r\nAre you sure to continue?");
	}
	else
	{
		confirmResult = confirm("点击测试后需要手动刷新目标机状态.\r\n确定继续吗？");
	}
	
	if (confirmResult)
	{
		getParams = "type=36&cmd=2&testObjDev=1";
		
		xmlhttp.open("POST", "/goform/formIPQAM", true);
		xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlhttp.setRequestHeader("Content-length", getParams.length);
		
		xmlhttp.onreadystatechange = function()
		{
			if (xmlhttp.readyState == 4)
			{
				if (language == 0)
				{
					alert("Test configuration updated successful,please refresh the status manually.");
				}
				else
				{
					alert("设置成功，请手动刷新目标机状态。");
				}
				PageLoadHandler();
			}
		}
		xmlhttp.send(getParams);
		return true;
	}
	else
	{
		PageLoadHandler();
	}
}

function SwitchDevBackup()
{
	var confirmResult;
	if (language == 0)
	{
		confirmResult = confirm("After the switch,you need to refresh backup status manually.\r\nAre you sure to continue?");
	}
	else
	{
		confirmResult = confirm("点击切换后需要手动刷新备份状态.\r\n确定继续吗？");
	}
	
	if (confirmResult)
	{
		getParams = "type=36&cmd=2&setDeviceSwitch=1";
		
		xmlhttp.open("POST", "/goform/formIPQAM", true);
		xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlhttp.setRequestHeader("Content-length", getParams.length);
		
		xmlhttp.onreadystatechange = function()
		{
			if (xmlhttp.readyState == 4)
			{
				if (language == 0)
				{
					alert("Switch configuration updated successful,please refresh the status manually.");
				}
				else
				{
					alert("设置成功，请手动刷新备份状态。");
				}
				PageLoadHandler();
			}
		}
		xmlhttp.send(getParams);
		return true;
	}
	else
	{
		PageLoadHandler();
	}
}
